require "API/DST_API"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Strength"

local _CARRY_BY_LEVEL = { 7, 8, 9, 11, 12, 14, 15, 16, 18, 20 }
local _MELEE_MULT_BY_LEVEL = { 80, 85, 90, 95, 100, 105, 110, 115, 120, 125 }   -- %
local _BLOCK_CHANCE_BY_LVL = {  2,  4,  6,  8,   10,  12,  14,  16,  18,  20 }  -- +%
local _PUSH_KD_BASE_BY_LVL = { 48, 85, 90, 95, 100, 105, 110, 115, 168, 175 }   -- %
local _CLIMB_TALL_BY_LVL   = {  2,  4,  6,  8,   10,  12,  14,  16,  18,  20 }  -- +%
local _MUSCLE_STRAIN_BY_LVL = {  1.4, 1.3, 1.2, 1.1, 1.0, 0.9, 0.8, 0.7, 0.6, 0.5 }  -- x

local active =  { color = ST.COLORS.leafgreen }
local removed = { color = ST.COLORS.orange }
local gained =  { color = ST.COLORS.yellow }

ST.addContributor(KEY, function(ctx)
    local lvl = ctx.getLevel()

    local cap          = _CARRY_BY_LEVEL[lvl]
    local meleeMult    = _MELEE_MULT_BY_LEVEL[lvl]
    local muscleStrain = _MUSCLE_STRAIN_BY_LVL[lvl]
    local blockPlus    = _BLOCK_CHANCE_BY_LVL[lvl]
    local pushBase     = _PUSH_KD_BASE_BY_LVL[lvl]
    local climbPlus    = _CLIMB_TALL_BY_LVL[lvl]

    -- Carry capacity
    ctx.add(ST.getText("IGUI_DST_Strength_val_Carry", tostring(cap or "-")), active)

    ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))

    ctx.add(ST.getText("IGUI_DST_Strength_val_MuscleStrain", tostring(muscleStrain or "-")))
    ctx.add(ST.getText("IGUI_DST_Strength_val_MeleeMult", tostring(meleeMult or "-")))
    ctx.add(ST.getText("IGUI_DST_Strength_val_Block", tostring(blockPlus or "-")))
    ctx.add(ST.getText("IGUI_DST_Strength_val_PushKD_Base", tostring(pushBase or "-")))
    ctx.add(ST.getText("IGUI_DST_Strength_val_ClimbTall", tostring(climbPlus or "-")))

    --------------------------------------------------------------------------------
    -- Trait transitions (Puny/Weak → cleared → Stout → Strong)
    --------------------------------------------------------------------------------

    local T_Puny   = ST.getText("UI_trait_weak")
    local T_Weak   = ST.getText("UI_trait_feeble")
    local T_Stout  = ST.getText("UI_trait_stout")
    local T_Strong = ST.getText("UI_trait_strong")

    ctx.addSeparator()

    if lvl == 1 then
        ctx.add(ST.getText("IGUI_DST_Trait_Active", T_Puny), active)

    elseif lvl == 2 then
        ctx.add(ST.getText("IGUI_DST_Trait_Removed", T_Puny), removed)
        ctx.add(ST.getText("IGUI_DST_Trait_Gained", T_Weak), gained)

    elseif lvl == 3 or lvl == 4 then
        ctx.add(ST.getText("IGUI_DST_Trait_Active", T_Weak), active)

    elseif lvl == 5 then
        ctx.add(ST.getText("IGUI_DST_Trait_Cleared"), active)

    elseif lvl == 6 then
        ctx.add(ST.getText("IGUI_DST_Trait_Gained", T_Stout), gained)

    elseif lvl == 7 or lvl == 8 then
        ctx.add(ST.getText("IGUI_DST_Trait_Active", T_Stout), active)

    elseif lvl == 9 then
        ctx.add(ST.getText("IGUI_DST_Trait_Removed", T_Stout), removed)
        ctx.add(ST.getText("IGUI_DST_Trait_Gained", T_Strong), gained)

    elseif lvl == 10 then
        ctx.add(ST.getText("IGUI_DST_Trait_Active", T_Strong), active)
    end
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)